var serial = {
	
  SerialPort: require('serialport'),
  port: null,
  Delimiter: require('@serialport/parser-delimiter'),
  parser: null,

  NotConnectedException: "Not Connected",

  // Indicates port has been bound for incoming data
  connectedReceive: false,
  connectedTransmit: false,

  // Receive callbacks
  callbacks: [],
  comPortsAvailableChangedCallback: null,
  initializedCallback: null,
  
  oldPortNames: [],
  
  // Serial Constructor
  initialize: function(initializedCb, receiveCb, comPortsAvailableChangedCb) {
    console.log("Initializing serial");
    
    this.connectedReceive = true;
    this.connectedTransmit = true;
    
    if (comPortsAvailableChangedCb !== "undefined" && comPortsAvailableChangedCb != null) {
      this.comPortsAvailableChangedCallback = comPortsAvailableChangedCb;
    }
    
    if (initializedCb !== "undefined" && initializedCb != null) {
      this.initializedCallback = initializedCb;
    }
    
    if (receiveCb !== "undefined" && receiveCb != null) {
      this.receive(receiveCb);
    }
    
    /*this.SerialPort.list(function (err, ports) {
      ports.forEach(function(port) {
        console.log(port);
      });
    });*/
    
    
    //this.port.on('data', this.receiveListener.bind(this));
    
    /*
      // Wait until here to set socket, otherwise it won't have been loaded yet
      this.socket = chrome.sockets.udp;
      // Attempt to bind to local port 4000
      this.connect(deviceIp, 4000, 4000, function(receiveStatus, transmitStatus) {
        //navigator.notification.alert("Connected receive=" + receiveStatus + ", transmit=" + transmitStatus, null, "Init", "OK");
        console.log("Networking initialized and bound");
        if (initializedCallback !== "undefined" && initializedCallback != null) {
          initializedCallback(receiveStatus, transmitStatus);
        }
        //navigator.notification.alert("Connected to device", null, "Init", "OK");
        if (receiveCallback !== "undefined" && receiveCallback != null) {
          this.receive(receiveCallback);
        }
      }.bind(this));
    */
	
  },
  deinitialize: function() {
	/*
    this.socket.close(this.socketInfo.socketId, function() {
    // Socket is now guaranteed to be closed
      this.socketInfo = null;
    }.bind(this));
	*/
  },
  connectPort: function(portName) {
    /*this.connectedReceive = true;
    this.connectedTransmit = true;
    
    if (this.initializedCallback !== "undefined" && this.initializedCallback != null) {
        this.initializedCallback(receiveStatus, transmitStatus);
      }
      if (receiveCallback !== "undefined" && receiveCallback != null) {
        this.receive(receiveCallback);
      }*/
    
    if (portName == undefined || portName.trim() == "") {
      return;
    }
    if (this.port != null && this.port.isOpen) {
      this.port.close();
    }
    this.port = new this.SerialPort(portName, {baudRate: 115200});
    this.port.on('open', function() {
      console.log("Port is open");
    }.bind(this));
    this.parser = this.port.pipe(new this.Delimiter({ delimiter: [0x7E, 0x7E] }));
    this.parser.on('data', this.receiveListener.bind(this));
  },
  getPorts: function() {
    var portNames = new Array();
    this.SerialPort.list(function (err, ports) {
      ports.forEach(function(port) {
        portNames.push(port.comName);
      });
      if (JSON.stringify(portNames) != JSON.stringify(this.oldPortNames))
      {
        this.oldPortNames = portNames;
        if (this.comPortsAvailableChangedCallback != null) {
          this.comPortsAvailableChangedCallback(portNames);
        }
      }
    }.bind(this));
  },
  isReadyToInitialize: function() {
    // Assume we're ready to init if socketInfo is null
    //return (this.socketInfo === null);
    return true;
  },
  stringToArrayBuffer: function(string) {
    var buffer = new ArrayBuffer(string.length);
    var bufView = new Uint8Array(buffer);
    for (var i=0; i < string.length; i++) {
      bufView[i] = string.charCodeAt(i);
    }
    return buffer;
  },
  // Data received
  receiveListener: function(data) {
    // Call all our stored callbacks
    //console.log("Received data, " + result.length + " bytes, " + this.callbacks.length + " callbacks");
	// Re-frame with flag bytes since lower levels expect
	//var gdl90Flag = Buffer.from('0x7e', 'hex');
	var gdl90Flag = new Uint8Array(1);
	gdl90Flag[0] = 0x7e;
	if (data[0] != 0x7e) {
	  data = Buffer.concat([gdl90Flag, data]);
	}
	if (data[data.length-1] != 0x7e) {
	  data = Buffer.concat([data, gdl90Flag]);
	}
	//console.log("RX: " + data.toString('hex'));
    for (var i=0; i < this.callbacks.length; i++) {
      this.callbacks[i](data);
    }
  },
  arrayBufferToString: function(bufer) {
    return String.fromCharCode.apply(null, new Uint8Array(buffer));
  },
  send: function(data, callback) {
    callback = callback || function() {};
    if (!this.connectedTransmit) throw this.NotConnectedException;
	var dataBuffer = Buffer.from(data);
	this.port.write(dataBuffer, function(sendResult) {
      callback(sendResult);
    }.bind(this));
	/*
    this.socket.send(this.socketInfo.socketId, data, this.remoteAddress, this.remotePort, function(sendResult) {
      callback(sendResult);
    }.bind(this));
	*/
  },
  sendString: function(stringData, callback) {
    var sendBuffer = this.stringToArrayBuffer(stringData);
    this.send(sendBuffer, callback);
  },
  receive: function(callback) {
    if (this.connectedReceive == false) throw this.NotConnectedException;
    this.callbacks.push(callback);
  },
  disconnect: function() {
	  /*
    if (this.socketInfo !== null) throw this.NotConnectedException;
    this.socket.close(this.socketInfo.socketId, function() {
      this.connected = false;
    }.bind(this));
	*/
  }
};
